
; Definitionen fr Mega88

; Belegungen der Atmel-Ports:

;*****************************************************************

;	PB0		ICP1/CLKO		CLOCK	FOST02	
;   PB1		OC1A			DATA	FOST02
;   PB2		SS/OC1B	
;   PB3		MOSI/OC2 		ISP     
;   PB4		MISO			ISP
;   PB5		MSCK			ISP
;	PB6		XTAL1/TOSC1		QUARZ
;	PB7		XTAL2/TOSC2		QUARZ
				
;   PC0		ADC0
;   PC1		ADC1
;   PC2		ADC2
;   PC3		ADC3			XCLR HP03S
;	PC4		ADC4/SDA		SDA  HP03S	
;	PC5		ADC5/SCL		SCK  HP03S

;   PD0		RxD
;   PD1		TxD
;   PD2		INT0			SDI  RFM02
;   PD3		INT1/OC2B		SCK  RFM02
;   PD4	    T0/XCK/PCINT20	CLK vom RFN02 in fr 32,768 MCLK HP03S
;   PD5		T1/OC0B			CS   RFM12 [nSEL]		
;   PD6		AIN0/OC0A		MCLK HP03S
;   PD7		AIN1/PCINT23	IRQ  RFM02 [nIRQ]	

;	FSK: Pullup

; Protokoll:
;  0 Sektornummer (ASCII, 0-9)
;  1 Sektornummer invertiert
;  2 Vorzeichen Temperatur 				ASCII
;  3 -  6 Temperatur in 1/100 Grad		ASCII
;  7 -  9 relative Feuchte in 1/10 mBar	ASCII
; 10 - 16 Luftdruck in 1/100 mBar		ASCII
; 17 Batteriestatus  0xA5 / 0x5A
; 18 Prfsumme Summe Byte 0 - 17 mod 256

;*****************************************************************

.equ	SENSOR			= 3

;--- Allgemeines -----------------------------------------------

.equ    F_CPU           = 8000000
.equ    CYCLES_PER_US   = ((F_CPU+500000)/1000000)

.equ	RFM_CLK			= 1250000

.equ	I2C_FREQUENZ	= 100000
.equ	I2C_PRESCALE	= 4
.equ	I2C_CLOCK		= F_CPU/((2*I2C_FREQUENZ*I2C_PRESCALE)-16)

.equ	STATUS_READ		= 0b00000111
.equ	STATUS_WRITE	= 0b00000110

.equ	TEMPERATUR_READ	= 0b00000011
.equ	FEUCHTE_READ	= 0b00000101

.equ	SOFT_RESET		= 0b00011110				; nach Reset mindestens 11ms warten

.equ	BATT_OK			= 0xA5
.equ	BATT_LOW		= 0x5A

.equ	DRUCK_KORR		= 70						; 48m Hhe ??????

;**************************** Port-Bits ***************************

.equ	FOST02_PORT		= PORTB
.equ	FOST02_PIN		= PINB
.equ	FOST02_DDR		= DDRB

.equ	FOST02_CLK		= PB0
.equ	FOST02_DATA		= PB1

.equ	RFM02_PORT		= PORTD
.equ	RFM02_PIN		= PIND
.equ	RFM02_DDR		= DDRD

.equ	RFM02_SDI		= PD2
.equ	RFM02_SCK		= PD3
.equ	RFM02_CS		= PD5
.equ	RFM02_IRQ		= PD7

.equ	HP03S_WRITE		= 0xEE
.equ	HP03S_READ		= 0xEF

.equ	HP03S_TEMP		= 0xE8
.equ	HP03S_DRUCK		= 0xF0

.equ	EEPROM_WRITE	= 0xA0
.equ	EEPROM_READ		= 0xA1

.equ	HP03S_PORT		= PORTC
.equ	HP03S_XCLR		= PC3

.equ	HP03S_MCLK		= PD6

;**************************** Ram-Reservierungen ******************

;--- Internes Ram ------------------------------------------------

.DSEG

.ORG    SRAM_START								; 160 Byte allgemein

DATA_BUF:	
SENSOR_NR:		.byte	 1
STATUS:			.byte	 1
S1_TYP:			.byte	 1
VORZEICHEN:		.byte    1
TEMPERATUR:		.byte	 5
S2_TYP:			.byte	 1
SPACE:			.byte	 1
FEUCHTE:		.byte	 5
S3_TYP:			.byte	 1
LUFTDRUCK:		.byte	 6
CHECKSUMME:		.byte	 1
DATA_BUF_END:

.equ	PAKET_LEN	= DATA_BUF_END - DATA_BUF

CAL_DATA:										; Kalibrierungsdaten aus EEPROM HP03S
C1_VAL:			.byte	2			
C2_VAL:			.byte	2
C3_VAL:			.byte	2
C4_VAL:			.byte	2
C5_VAL:			.byte	2
C6_VAL:			.byte	2
C7_VAL:			.byte	2
AA_VAL:			.byte	1
BB_VAL:			.byte	1
CC_VAL:			.byte	1
DD_VAL:			.byte	1

D1_VAL:			.byte	2						; Druck
D2_VAL:			.byte	2						; Temperatur

DELTA:			.byte	2						; Zwischenwerte Berechnung Luftdruck HP04S
C_VAL:			.byte	1						; AA oder BB
DELTA_14:		.byte	4						; delta^2 * C_VAL / 2^14
DUT:			.byte	2
OFFSET:			.byte	4
SENS:			.byte	4
X_VAL:			.byte	4

;**************************** Register ****************************

;--- lower Register -----------------------------------------------

.def	MUL_L		= r0
.def	MUL_H		= r1

.def	NULL		= r2

.def	SREG_SAVE	= r3

.def	FEUCHTE_L	= r4
.def	FEUCHTE_H	= r5

.def	TEMP_L		= r6
.def	TEMP_H		= r7

.def	HP03S_L		= r8
.def	HP03S_H		= r9

.def	BCD0		= r13						; BCD Wert Digits 1 und 0
.def	BCD1		= r14						; BCD Wert Digits 3 und 2
.def	BCD2		= r15						; BCD Wert Digit 4

.equ	BCD0_ADR	= 13						; Address von tBCD0
.equ	BCD2_ADR	= 15						; Address von tBCD1

;--- higher Register ----------------------------------------------

.def	MUL_E_0		=r16						; result byte 0 (LSB)
.def	MUL_E_1		=r17						; result byte 1
.def	MUL_E_2		=r18						; result byte 2
.def	MUL_E_3		=r19						; result byte 3 (MSB)
.def	MUL_1_L		=r20						; multiplicand low byte
.def	MUL_1_H		=r21						; multiplicand high byte
.def	MUL_2_L		=r22						; multiplier low byte
.def	MUL_2_H		=r23						; multiplier high byte


.def	TEMP_3		= r22                   	; Temp-Register
.def	TEMP_2		= r23                   	; Temp-Register
.def	TEMP_1		= r24                   	; Temp-Register
.def	TEMP_0		= r25						; Temp-Register

; r26/r27, r28/r29, r30/r31 fr X,Y,Z reserviert 

;--- Macros -------------------------------------------------------

.macro  load_p                      			; ldt 16Bit @1 nach @0 High und @0 Low

        ldi     @0H,HIGH(@1)
        ldi     @0L,LOW(@1)

.endmacro

