;************************* FOST02 / SFH11 Routinen *************************

;*************************** Sensor Write Start ****************************
; Sub: Sendet Startcondition
; Parameter:	-
; Return:		-
; Scratch-Reg:	-
;***************************************************************************

fost02_write_start:
		sbi		FOST02_PORT,fost02_CLK	; Clk auf H
		nop
		nop
		sbi		FOST02_DDR,fost02_DATA	; Data als Ausgang L
		nop
		nop
		cbi		FOST02_PORT,fost02_CLK	; Clk auf L
		nop
		nop
		nop
		nop
		sbi		FOST02_PORT,fost02_CLK	; Clk auf H
		nop
		nop
		cbi		FOST02_DDR,fost02_DATA	; Data als Eingang H
		nop
		nop
		cbi		FOST02_PORT,fost02_CLK	; Clk auf L
		nop
		nop
			
		ret

;*************************** Sensor Write Ack ******************************
; Sub: Sendet ACK
; Parameter:	-
; Return:		-
; Scratch-Reg:	-
;***************************************************************************

fost02_write_ack:
		nop
		nop
		sbi		FOST02_DDR,fost02_DATA	; Data als Ausgang L
		nop
		nop
		sbi		FOST02_PORT,fost02_CLK	; Clk auf L
		nop
		nop
		nop
		nop
		cbi		FOST02_PORT,fost02_CLK	; Clk auf H
		nop
		nop
		cbi		FOST02_DDR,fost02_DATA	; Data als Eingang H
		nop
		nop

		ret

;************************** Sensor Write NAck ******************************
; Sub: Sendet NACK
; Parameter:	-
; Return:		-
; Scratch-Reg:	-
;***************************************************************************

fost02_write_nack:
		nop
		nop
		sbi		FOST02_PORT,fost02_CLK	; Clk auf L
		nop
		nop
		nop
		nop
		cbi		FOST02_PORT,fost02_CLK	; Clk auf H
		nop
		nop


		ret

;************************** Sensor Read Ack ********************************
; Sub: Wartet auf Ack vom Sensor
; Parameter:	-
; Return:		-
; Scratch-Reg:	-
;***************************************************************************

fost02_read_ack:
		
fost02_read_ack_loop:
		sbic	FOST02_PIN,FOST02_DATA	; Ack vom Sensor?
		rjmp	fost02_read_ack_loop	; nein

		sbi		FOST02_PORT,FOST02_CLK	; Clk auf H		; 9. Clock
		nop
		nop
		cbi		FOST02_PORT,FOST02_CLK	; Clk auf L
		nop
		nop

		ret

;************************** Sensor Wait Ready ******************************
; Sub: Wartet auf Ende der Wandlung
; Parameter:	-
; Return:		-
; Scratch-Reg:	-
;***************************************************************************

fost02_wait_ready:	
		sbic	FOST02_PIN,FOST02_DATA	; auf Data L vom Sensor warten
		rjmp	fost02_wait_ready

		ret

;************************** Sensor Write Cmd *******************************
; Sub: Sendet Commando zum Sensor
; Parameter:	TEMP_0 Kommando
; Return:		-
; Scratch-Reg:	TEMP_1
;***************************************************************************

fost02_write_cmd:
		ldi		TEMP_1,8				; Anzahl Bits

fost02_write_cmd_loop:
		lsl		TEMP_0					; Bit in Carry
		brcs	fost02_write_cmd_loop_high	; Bit H

		sbi		FOST02_DDR,FOST02_DATA	; Data als Ausgang L

fost02_write_cmd_loop_high:
		nop
		nop
		sbi		FOST02_PORT,FOST02_CLK	; Clk auf H
		nop
		nop
		nop
		cbi		FOST02_PORT,FOST02_CLK	; Clk auf L
		nop
		nop
		nop

		cbi		FOST02_DDR,FOST02_DATA	; Data als Eingang H

		dec		TEMP_1
		brne	fost02_write_cmd_loop
		
		ret

;************************** Sensor Read Daten ******************************
; Sub: Liest Daten vom Sensor
; Parameter:	-
; Return:		TEMP_0 Daten
; Scratch-Reg:	TEMP_1
;***************************************************************************

fost02_read_daten:	
		ldi		TEMP_1,8				; Anzahl Bits

fost02_read_daten_loop:
		sbi		FOST02_PORT,FOST02_CLK	; Clk auf H
		nop
		nop
		nop
		
		clc
		sbic	FOST02_PIN,FOST02_DATA	; Datenbit lesen
		sec
		
		cbi		FOST02_PORT,FOST02_CLK	; Clk auf L

		rol		TEMP_0					; reinschieben
		dec		TEMP_1
		brne	fost02_read_daten_loop	

		ret

;************************** Sensor Reset ***********************************
; Sub: Sendet Reset zum Sensor
; Parameter:	-
; Return:		-
; Scratch-Reg:	TEMP_0, TEMP_1
;***************************************************************************

fost02_reset:
		rcall	fost02_write_start
		ldi		TEMP_0,SOFT_RESET
		rcall	fost02_write_cmd
		rcall	fost02_read_ack

		rcall	wait_20ms

		ret

;************************** Sensor Status **********************************
; Sub: Liest Status vom Sensor
; Parameter:	-
; Return:		Status TEMP_0
; Scratch-Reg:	TEMP_0, TEMP_1
;***************************************************************************

fost02_status:
		rcall	fost02_write_start
		ldi		TEMP_0,STATUS_READ
		rcall	fost02_write_cmd
		rcall	fost02_read_ack

		rcall	fost02_read_daten
		rcall	fost02_write_nack

		ret

;************************** Sensor Feuchte *********************************
; Sub: Liest Feuchte vom Sensor
; Parameter:	-
; Return:		Feuchte FEUCHTE_H, FEUCHTE_L
; Scratch-Reg:	TEMP_0, TEMP_1
;***************************************************************************

fost02_feuchte:
		rcall	fost02_write_start
		ldi		TEMP_0,FEUCHTE_READ
		rcall	fost02_write_cmd
		rcall	fost02_read_ack

		rcall	fost02_wait_ready			; auf Ende der Messung warten

		rcall	fost02_read_daten
		mov		FEUCHTE_H,TEMP_0
		rcall	fost02_write_ack

		rcall	fost02_read_daten
		mov		FEUCHTE_L,TEMP_0
		rcall	fost02_write_nack

		ret

;************************** Sensor Temperatur ******************************
; Sub: Liest Temperatur vom Sensor
; Parameter:	-
; Return:		Feuchte TEMP_H, TEMP_L
; Scratch-Reg:	TEMP_0, TEMP_1
;***************************************************************************

fost02_temperatur:
		rcall	fost02_write_start
		ldi		TEMP_0,TEMPERATUR_READ
		rcall	fost02_write_cmd
		rcall	fost02_read_ack

		rcall	fost02_wait_ready			; auf Ende der Messung warten

		rcall	fost02_read_daten
		mov		TEMP_H,TEMP_0
		rcall	fost02_write_ack

		rcall	fost02_read_daten
		mov		TEMP_L,TEMP_0
		rcall	fost02_write_nack

		ret

