;**************************** HP03S Routinen *************************

;*********************************************************************
;  Liest die Calibrierungsdaten aus dem HP03S
;  In:  -	 
;  Out: Daten im Ram
;  Scratch-Reg: Z, TEMP_0,  TEMP_1
;*********************************************************************

hp03_read_eeprom:
		load_p	Z,CAL_DATA

		ldi		TEMP_0,(1<<TWINT) | (1<<TWSTA) | (1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$08				; Start transmitted
		brne	hp03_read_eeprom_end

		ldi		TEMP_0,EEPROM_WRITE
		sts		TWDR,TEMP_0				; Adresse schreiben
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$18				; Adresse gesendet und Ack empfangen

		brne	hp03_read_eeprom_end

		ldi		TEMP_0,16
		sts		TWDR,TEMP_0				; EEPROM-Adresse senden
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$28				; Sub-Adresse gesendet und Ack empfangen

		brne	hp03_read_eeprom_end

		ldi		TEMP_0,(1<<TWINT)+(1<<TWSTA)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$10				; Repeat-Start transmitted

		brne	hp03_read_eeprom_end

		ldi		TEMP_0,EEPROM_READ
		sts		TWDR,TEMP_0				; Adresse schreiben
		ldi		TEMP_0,(1<<TWINT) | (1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$40				; Adresse gesendet und Ack empfangen
		brne	hp03_read_eeprom_end

		ldi		TEMP_1,17
		
hp03_read_eeprom_loop:				
		ldi		TEMP_0,(1<<TWINT) | (1<<TWEN) | (1<<TWEA)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$50				; Daten holen und Ack senden
		brne	hp03_read_eeprom_end
		
		lds		TEMP_0,TWDR
		st		Z+,TEMP_0

		dec		TEMP_1
		brne	hp03_read_eeprom_loop

		ldi		TEMP_0,(1<<TWINT) | (1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$58				; Daten holen und Nack senden
		brne	hp03_read_eeprom_end

		lds		TEMP_0,TWDR
		st		Z+,TEMP_0

hp03_read_eeprom_end:							; Stop senden
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)+(1<<TWSTO)
		sts		TWCR,TEMP_0

hp03_read_eeprom_end_loop:
		lds		TEMP_0,TWCR				; warten bis Stop fertig
		sbrc	TEMP_0,TWSTO		
		rjmp	hp03_read_eeprom_end_loop

		ret

;*********************************************************************
; Sendet Kommando an I2C (HP03S)
; In:  TEMP_0 Kommando 
; Out: -
; Scratch-Reg: TEMP_0
;*********************************************************************

hp03_send_cmd:
		mov		TEMP_2,TEMP_0			; merken

		ldi		TEMP_0,(1<<TWINT) | (1<<TWSTA) | (1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$08				; Start transmitted
		brne	hp03_i2c_write_end

		ldi		TEMP_0,HP03S_WRITE
		sts		TWDR,TEMP_0				; Adresse schreiben
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$18				; Adresse gesendet und Ack empfangen

		brne	hp03_i2c_write_end

		ldi		TEMP_0,0xFF
		sts		TWDR,TEMP_0				; Kommando Byte 1 senden
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$28				; Sub-Adresse gesendet und Ack empfangen

		brne	hp03_i2c_write_end

		sts		TWDR,TEMP_2				; Kommando Byte 2 senden
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

hp03_i2c_write_end:						; Stop senden
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)+(1<<TWSTO)
		sts		TWCR,TEMP_0

hp03_i2c_write_end_loop:
		lds		TEMP_0,TWCR				; warten bis Stop fertig
		sbrc	TEMP_0,TWSTO		
		rjmp	hp03_i2c_write_end_loop

		rcall	wait_20ms
		rcall	wait_20ms
			
		ldi		TEMP_0,(1<<TWINT)+(1<<TWSTA)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$08				; Start transmitted
		brne	hp03_i2c_read_end

		ldi		TEMP_0,HP03S_WRITE
		sts		TWDR,TEMP_0				; Adresse schreiben
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$18				; Adresse gesendet und Ack empfangen

		brne	hp03_i2c_read_end

		ldi		TEMP_0,0xFD
		sts		TWDR,TEMP_0				; Kommando senden
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$28				; Kommando gesendet und Ack empfangen

		brne	hp03_i2c_read_end

		ldi		TEMP_0,(1<<TWINT)+(1<<TWSTA)+(1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$10				; Repeat-Start transmitted

		brne	hp03_i2c_write_end

		ldi		TEMP_0,HP03S_READ
		sts		TWDR,TEMP_0				; Adresse schreiben
		ldi		TEMP_0,(1<<TWINT) | (1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$40				; Adresse gesendet und Ack empfangen
		brne	hp03_i2c_read_end

		ldi		TEMP_0,(1<<TWINT) | (1<<TWEN) | (1<<TWEA)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$50				; Daten holen und Ack senden
		brne	hp03_i2c_read_end
		
		lds		HP03S_H,TWDR

		ldi		TEMP_0,(1<<TWINT) | (1<<TWEN)
		rcall	hp03_i2c_send_byte

		cpi		TEMP_0,$58				; Daten holen und Nack senden
		brne	hp03_i2c_read_end

		lds		HP03S_L,TWDR

hp03_i2c_read_end:							; Stop senden
		ldi		TEMP_0,(1<<TWINT)+(1<<TWEN)+(1<<TWSTO)
		sts		TWCR,TEMP_0

hp03_i2c_end_loop:
		lds		TEMP_0,TWCR				; warten bis Stop fertig
		sbrc	TEMP_0,TWSTO		
		rjmp	hp03_i2c_end_loop

		ret

;*********************************************************************
;  Sendet ein Byte per I2C
;  zu startenden Funktion in TEMP_0, Rckgabe Flags in TEMP_0
;	
;
;  Scratch-Reg: TEMP_0
;*********************************************************************

hp03_i2c_send_byte:
		sts		TWCR,TEMP_0
		
hp03_i2c_send_byte_wait:
		lds		TEMP_0,TWCR
		sbrs	TEMP_0,TWINT
		rjmp	hp03_i2c_send_byte_wait	; noch nicht fertig			

		lds		TEMP_0,TWSR
		andi	TEMP_0,0b11111000		; Flags maskieren

		ret

;*********************************************************************
; Liest Temperatur und Luftdruckwert aus dem HP03S
; In:  -
; Out: D1/D2 im Ram
; Scratch-Reg: TEMP_0
;*********************************************************************

hp03s_luftdruck:
		load_p	Z,0xC0E0						; Power Settings: Quarz ein
		rcall	rfm02_send_cmd

		sbi		HP03S_PORT,HP03S_XCLR

		rcall	wait_2ms

		ldi		TEMP_0,HP03S_DRUCK
		rcall	hp03_send_cmd
		sts		D1_VAL+0,HP03S_H
		sts		D1_VAL+1,HP03S_L

		ldi		TEMP_0,HP03S_TEMP
		rcall	hp03_send_cmd
		sts		D2_VAL+0,HP03S_H
		sts		D2_VAL+1,HP03S_L

		cbi		HP03S_PORT,HP03S_XCLR

		load_p	Z,0xC002						; alles aus, WakeUp-Timer ein
		rcall	rfm02_send_cmd

		load_p	Z,0xC440						; sleep, noch 64 Takte
		rcall	rfm02_send_cmd

		ret

