
;************************** Mathe Routinen ************************************

;******************************************************************************
;*
;* FUNCTION
;*	mul16x16_32
;* DECRIPTION
;*	Unsigned multiply of two 16bits numbers with 32bits result.
;* USAGE
;*	r19:r18:r17:r16 = r23:r22 * r21:r20
;* STATISTICS
;*	Cycles :	17 + ret
;*	Words :		13 + ret
;*	Register usage: r0 to r2 and r16 to r23 (11 registers)
;* NOTE
;*	Full orthogonality i.e. any register pair can be used as long as
;*	the 32bit result and the two operands does not share register pairs.
;*	The routine is non-destructive to the operands.
;*
;******************************************************************************

math_mul16x16_32:
	mul		MUL_2_H, MUL_1_H				; ah * bh
	movw	MUL_E_3:MUL_E_2, MUL_H:MUL_L
	mul		MUL_2_L, MUL_1_L				; al * bl
	movw	MUL_E_1:MUL_E_0, MUL_H:MUL_L
	mul		MUL_2_H, MUL_1_L				; ah * bl
	add		MUL_E_1, MUL_L
	adc		MUL_E_2, MUL_H
	adc		MUL_E_3, NULL
	mul		MUL_1_H, MUL_2_L				; bh * al
	add		MUL_E_1, MUL_L
	adc		MUL_E_2, MUL_H
	adc		MUL_E_3, NULL

	ret

;******************************************************************************
;*
;* FUNCTION
;*	muls16x16_32
;* DECRIPTION
;*	Signed multiply of two 16bits numbers with 32bits result.
;* USAGE
;*	r19:r18:r17:r16 = r23:r22 * r21:r20
;* STATISTICS
;*	Cycles :	19 + ret
;*	Words :		15 + ret
;*	Register usage: r0 to r2 and r16 to r23 (11 registers)
;* NOTE
;*	The routine is non-destructive to the operands.
;*
;******************************************************************************

math_muls16x16_32:
	muls	MUL_1_H, MUL_2_H				; (signed)ah * (signed)bh
	movw	MUL_E_3:MUL_E_2, MUL_H:MUL_L
	mul		MUL_1_L, MUL_2_L				; al * bl
	movw	MUL_E_1:MUL_E_0, MUL_H:MUL_L
	mulsu	MUL_1_H, MUL_2_L				; (signed)ah * bl
	sbc		MUL_E_3, NULL
	add		MUL_E_1, MUL_L
	adc		MUL_E_2, MUL_H
	adc		MUL_E_3, NULL
	mulsu	MUL_2_H, MUL_1_L				; (signed)bh * al
	sbc		MUL_E_3, NULL
	add		MUL_E_1, MUL_L
	adc		MUL_E_2, MUL_H
	adc		MUL_E_3, NULL

	ret

;******************************************************************************

math_mulu_32_8:
	clr		TEMP_0
	clr		TEMP_1
	clr		TEMP_2
	clr		TEMP_3
	clr		MUL_1_H

math_mul_32_8_loop:
	add		TEMP_0,MUL_E_0
	adc		TEMP_1,MUL_E_1
	adc		TEMP_2,MUL_E_2
	adc		TEMP_3,MUL_E_3
	adc		MUL_1_H,MUL_E_3

	dec		MUL_1_L
	brne	math_mul_32_8_loop

	ret

;******************************************************************************
; MUL_1_H, TEMP_3, TEMP_2, TEMP_1, TEMP_0
; / 65536 -> MUL_1_H, TEMP_3, TEMP_2 

math_div_2_14:
	ldi		TEMP_0,6		; /64

math_div_2_14_loop:
	lsr		MUL_1_H			; /2
	ror		TEMP_3
	ror		TEMP_2
	ror		TEMP_1
	dec		TEMP_0
	brne	math_div_2_14_loop

	sts		DELTA_14,MUL_1_H
	sts		DELTA_14+1,TEMP_3
	sts		DELTA_14+2,TEMP_2
	sts		DELTA_14+3,TEMP_1

	ret

;******************************************************************************
; MUL_1_H, TEMP_3, TEMP_2, TEMP_1, TEMP_0
; / 65536 -> MUL_1_H, TEMP_3, TEMP_2 

math_div_2_14_2:
	ldi		TEMP_0,6		; /64

math_div_2_14_2_loop:
	lsr		MUL_E_3			; /2
	ror		MUL_E_2
	ror		MUL_E_1
	ror		MUL_E_0
	dec		TEMP_0
	brne	math_div_2_14_2_loop

	mov		MUL_E_0,MUL_E_1
	mov		MUL_E_1,MUL_E_2
	mov		MUL_E_2,MUL_E_3
	clr		MUL_E_3

	ret

;******************************************************************************
; (delta * 2^cc - delta_14) / 2^cc
math_delta_div_cc:

	lds		TEMP_0,CC_VAL

math_delta_div_cc_loop:
	clc
	sbrc	MUL_E_3,7			; positiv
	sec
	
	ror		MUL_E_3
	ror		MUL_E_2
	ror		MUL_E_1
	ror		MUL_E_0

	dec		TEMP_0
	brne	math_delta_div_cc_loop

	sts		DUT,MUL_E_1			; Wertebereich ausreichend???
	sts		DUT+1,MUL_E_0

	ret

;******************************************************************************
; / 2^10
math_offset_2_10:

	ldi		TEMP_0,2			; /4

math_offset_2_10_loop:
	clc
	sbrc	MUL_E_3,7			; positiv
	sec
	
	ror		MUL_E_3	
	ror		MUL_E_2
	ror		MUL_E_1
	ror		MUL_E_0
	dec		TEMP_0
	brne	math_offset_2_10_loop

	mov		MUL_E_0,MUL_E_1
	mov		MUL_E_1,MUL_E_2
	mov		MUL_E_2,MUL_E_3
	ser		MUL_E_3
	sbrs	MUL_E_2,7
	clr		MUL_E_3

	ret

