;************************** RFM02 Sende Routinen ***************************

;***************************** RFM12 Send CMD ******************************
; Sub: Sendet 16Bit Kommando aus Z
; Parameter:	Z Kommando
; Return:		-
; Scratch-Reg:	Z, TEMP_0, TEMP_1
;***************************************************************************

rfm02_send_cmd:
		cbi		RFM02_PORT,RFM02_CS				; RFM02 aktiv

		mov		TEMP_0,ZH
		rcall	rfm02_send_8bit
		mov		TEMP_0,ZL
		rcall	rfm02_send_8bit

		sbi		RFM02_PORT,RFM02_CS				; CS wieder H

		ret

;***************************** RFM12 Send CMD ******************************
; Sub: Sendet Byte aus TEMP_0 fr Send Kommando
; Parameter:	TEMP_0 Daten
; Return:		-
; Scratch-Reg:	TEMP_0, TEMP_1
;***************************************************************************

rfm02_send_8bit:
		push	TEMP_2
		ldi		TEMP_1,8						; Anzahl Bits
		clr		TEMP_2							; Rckgabe von nIRQ bei Status

rfm02_send_8bit_loop:
		sbi		RFM02_PORT,RFM02_SDI			; Daten auf L
		sbrs	TEMP_0,7
		cbi		RFM02_PORT,RFM02_SDI			; nein, also auf L
		nop
		sbi		RFM02_PORT,RFM02_SCK			; Clock auf H
		nop
		nop
		nop
		sbic	RFM02_PIN,RFM02_IRQ
		sec										; Carry setzen

		rol		TEMP_2							; in Rckgabewert reinschieben
		nop
		nop

rfm02_send_8bit_loop_no:
		nop
		nop
		cbi		RFM02_PORT,RFM02_SCK			; Clock wieder L
		lsl		TEMP_0							; Ausgabewert
		dec		TEMP_1							; Bitzhler
		brne	rfm02_send_8bit_loop

		mov		TEMP_0,TEMP_2

		pop		TEMP_2
		ret

;***************************** RFM12 Init **********************************
; Sub: Initialisiert den RFM02
; Parameter:	-
; Return:		-
; Scratch-Reg:	Z, TEMP_0, TEMP_1
;***************************************************************************

rfm02_init:
		load_p	Z,0xCC00						; Status lesen
		rcall	rfm02_send_cmd

;Powermanagement:
; 0xc0 a1 a0 ex es ea eb et dc
		load_p	Z,0xC0E0						; Power Settings: Quarz ein, Synthesizer und PA ein bei Send-Command
		rcall	rfm02_send_cmd

;LowBatt, Bit-Sync:
;0xc2 dwc 0 ebs t4 t3 t2 t1 t0
		load_p	Z,0xC2A0						; low bat detector, TX Bit Sync, WakUp-Timer Calibrierung aus
		rcall	rfm02_send_cmd

;Config:
;100 b1 b0 d2 d1 d0 x3 x2 x1 x0 ms m2 m1 m0 -> 0x8xxx / 0x9xxx
; b1 b0 - Band / d2..d0 - Clock Output / x3...x0 - Quarzkapazitt / ms Frequenz-Shift-Flag / m2...m0 - Shigt-Wert
		load_p	Z,0x8983						; Control: 1,25MHz Clock Out, 12,5pF Last Quarz, 120kHz Shift
		rcall	rfm02_send_cmd

		load_p	Z,0xA620						; Frequenz: 430MHz + (0,0025 * 0x620) -> 433,92MHz
		rcall	rfm02_send_cmd

		load_p	Z,0xB400						; Power 4 * -3dBm -> .12dBm 
		rcall	rfm02_send_cmd

		load_p	Z,0xD2C0						; Set PLL: set 33%
		rcall	rfm02_send_cmd

;Baudrate:
; 0xC8 r7 r6 r5 r4 r3 r2 r1 r1 -> (344827 / Baudrate) - 1
		load_p	Z,0xC810						; Baudrate: 344827 / 19200 = 17 - 1 -> 0x10
		rcall	rfm02_send_cmd
		
;WakeUp Timer:
; 0b111 r4 r3 r2 r1 r0 m7 m6 m5 m4 m3 m2 m1 m0 -> 2^r * m in ms ??????
		load_p	Z,0xE500 + 200					; WakeUp-Timer 2^7 *234ms ~ 30s ???!! nicht 1ms sondern 10ms !!???
		rcall	rfm02_send_cmd

		load_p	Z,0xC002						; alles aus, WakeUp-Timer ein
		rcall	rfm02_send_cmd

		load_p	Z,0xC440						; sleep, noch 64 Takte
		rcall	rfm02_send_cmd

		ret

;************************** RFM12 Send Daten *******************************
; Sub: Sendet dem Ihalt von DATA_BUF
; Parameter:	-
; Return:		-
; Scratch-Reg:	Z, TEMP_0, TEMP_1
;***************************************************************************

rfm02_send_data:
		load_p	Z,0xC0E0						; einschalten
		rcall	rfm02_send_cmd

		load_p	Y,DATA_BUF						; Zeiger auf Buffer
		ldi		TEMP_2,PAKET_LEN
		ldi		TEMP_0,0xC6						; Kommando Daten

		cbi		RFM02_PORT,RFM02_CS				; RFM02 aktiv
		rcall	rfm02_send_8bit

		ldi		TEMP_0,0xAA						; Sync
		rcall	rfm02_send_byte
		ldi		TEMP_0,0xAA
		rcall	rfm02_send_byte
		ldi		TEMP_0,0xAA
		rcall	rfm02_send_byte
		ldi		TEMP_0,0x2D
		rcall	rfm02_send_byte
		ldi		TEMP_0,0xD4
		rcall	rfm02_send_byte

rfm02_send_data_byte_loop:
		ld		TEMP_0,Y+
		rcall	rfm02_send_byte		
		dec		TEMP_2
		brne	rfm02_send_data_byte_loop

rfm02_send_data_byte_wait_low:					; auf Ende der bertragung letztes Byte warten
		sbis	RFM02_PIN,RFM02_IRQ
		rjmp	rfm02_send_data_byte_wait_low		

rfm02_send_data_byte_wait_high:
		sbic	RFM02_PIN,RFM02_IRQ
		rjmp	rfm02_send_data_byte_wait_high		

rfm02_send_data_byte_wait_end:					; auf Ende Poer Off warten
		sbis	RFM02_PIN,RFM02_IRQ
		rjmp	rfm02_send_data_byte_wait_end		

		sbi		RFM02_PORT,RFM02_CS				; CS wieder H

		sbi		RFM02_PORT,RFM02_SDI			; Daten auf H

		load_p	Z,0xC002						; alles aus, WakeUp-Timer ein
		rcall	rfm02_send_cmd

		load_p	Z,0xC440						; sleep, noch 64 Takte
		rcall	rfm02_send_cmd

		ret

;************************** RFM12 Send Byte ********************************
; Sub: Sendet ein Datenbyte zum RFM02, Timing durch nIRQ
; Parameter:	TEMP_0 Daten
; Return:		-
; Scratch-Reg:	Z, TEMP_0, TEMP_1
;***************************************************************************

rfm02_send_byte:
		ldi		TEMP_1,8						; Anzahl Bits

rfm02_send_byte_loop:
		sbis	RFM02_PIN,RFM02_IRQ				; warten auf Anforderung H
		rjmp	rfm02_send_byte_loop

rfm02_send_byte_irq:
		sbic	RFM02_PIN,RFM02_IRQ				; warten auf Ende IRQ
		rjmp	rfm02_send_byte_irq
		
		sbi		RFM02_PORT,RFM02_SDI			; auf H
		sbrs	TEMP_0,7
		cbi		RFM02_PORT,RFM02_SDI			; auf L

rfm02_send_byte_loop_end:
		lsl		TEMP_0
		dec		TEMP_1
		brne	rfm02_send_byte_loop

		ret

;*********************************************************************
;  Testet Batteriespannung
;  In:  -
;  Out: TEMP_0
;  Scratch-Reg: Z, TEMP_0
;*********************************************************************

rfm02_check_spannung:
		load_p	Z,0xC0E4						; einschalten
		rcall	rfm02_send_cmd

		ldi		TEMP_3,4						; 2,2V + 4*0,1V = 2,6V

rfm02_check_spannung_loop:
		load_p	Z,0xC2A0
		or		ZL,TEMP_3
		rcall	rfm02_send_cmd

		load_p	Z,0xCC00						; Status read
		rcall	rfm02_send_cmd

		sbrc	TEMP_0,2						;LowPowerDetektor	
		rjmp	rfm02_check_spannung_end
		inc		TEMP_3
		cpi		TEMP_3,19						; 2.2V + 19*0,1V = 4,1V
		brne	rfm02_check_spannung_loop

rfm02_check_spannung_end:
		load_p	Z,0xC002						; alles aus, WakeUp-Timer ein
		rcall	rfm02_send_cmd

		load_p	Z,0xC440						; sleep, noch 64 Takte
		rcall	rfm02_send_cmd

		dec		TEMP_3
		
		cpi		TEMP_3,8
		brlo	rfm02_check_spannung_no_3
		
		lds		TEMP_1,DATA_BUF+13
		inc		TEMP_1
		sts		DATA_BUF+13,TEMP_1
		subi	TEMP_3,8
		rjmp	rfm02_check_spannung_ok

rfm02_check_spannung_no_3:
		subi	TEMP_3,-2

rfm02_check_spannung_ok:
		ori		TEMP_3,'0'
		sts		DATA_BUF+15,TEMP_3

		ret

