;********************** Allgemeine Subroutinen ***********************

;*********************************************************************				 

wait_2ms:
		push	XH
		push	XL

		ldi		XH,high(4000)					; ca. 2ms warten
		ldi		XL,low(4000)
		rjmp	wait_loop

wait_20ms:
		push	XH
		push	XL

		ldi		XH,high(40000)					; ca. 20ms warten
		ldi		XL,low(40000)

wait_loop:
		sbiw	X,1
		brne	wait_loop

		pop		XL
		pop		XH
		ret

;*********************************************************************				 

checksum:
		load_p	Z,DATA_BUF
		ldi		TEMP_1,PAKET_LEN-1
		clr		TEMP_2

checksum_loop:
		ld		TEMP_0,Z+
		eor		TEMP_2,TEMP_0
		dec		TEMP_1
		brne	checksum_loop

		st		Z,TEMP_2						; Prfsumme speichern

		ret

;*********************************************************************
;  Initialisiert DATA_BUF mit 0x55 -> kein Sensor
;  In:  DATA_BUF
;  Out: DATA_BUF
;  Scratch-Reg: Z, TEMP_0
;*********************************************************************

init_data_buf:
		load_p	Z,(2*buf_default)
		load_p	Y,DATA_BUF
		ldi		TEMP_1,PAKET_LEN
init_data_buf_loop:
		lpm		TEMP_0,Z+
		st		Y+,TEMP_0
		dec		TEMP_1
		brne	init_data_buf_loop

		ret			

;*********************************************************************
;  16Bit bin to BCD (eigentlich packed-BCD, immer 2 Stellen in einem Register)
;  In: TEMP_0 (L), TEMP_1 (H)
;  Out: BCD2 (x/4), BCD1 (3/2), BCD0 (1/0)
;  Scratch-Reg: TEMP_0, TEMP_1, TEMP_2, TEMP_3, ZH, ZL
;*********************************************************************

bin2BCD16:
		ldi		TEMP_2,16						; Bitzhler
		clr		BCD2							; Ergebnis lschen (3 bytes)
		clr		BCD1
		clr		BCD0
		clr		ZH

bin2BCD16_loop:
		lsl		TEMP_0							; Input schieben
		rol		TEMP_1							; durch alle Bytes
		rol		BCD0				
		rol		BCD1	
		rol		BCD2
		dec		TEMP_2							; Bitzhler
		breq	bin2BCD16_end					; fertig ?

		ldi		r30,BCD2_ADR+1					; Z auf Ergebnis MSB + 1

bin2BCD16_encode:
		ld		TEMP_3,-Z						; (Z) holen mit Pre-decrement
		subi	TEMP_3,-$03						; + $03
		sbrc	TEMP_3,3						; wenn Bit 3 nicht 0
		st		Z,TEMP_3						; speichern
		ld		TEMP_3,Z						; (Z) holen
		subi	TEMP_3,-$30						; + $30
		sbrc	TEMP_3,7						; wenn Bit 7 nicht 0
		st		Z,TEMP_3						; speichern
		cpi		ZL,BCD0_ADR						; alle erledigt??
		brne	bin2BCD16_encode				; nein, weiter

		rjmp	bin2BCD16_loop

bin2BCD16_end:
		ret

;*********************************************************************
;  Zeigt 16Bit-Wert an
;  Out   : Wert per UART schicken
;  Scratch-Reg: TEMP_A
;*********************************************************************

show_16bit_wert_temp:
		rcall	bin2BCD16

		load_p	Z,TEMPERATUR

		mov		TEMP_0,BCD1
		swap	TEMP_0
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0
	
		mov		TEMP_0,BCD1
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		ldi		TEMP_0,','			// Komma
		st		Z+,TEMP_0

		mov		TEMP_0,BCD0
		swap	TEMP_0
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		mov		TEMP_0,BCD0
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		ret

;*********************************************************************
;  Zeigt 16Bit-Wert an
;  Out   : Wert per UART schicken
;  Scratch-Reg: TEMP_A
;*********************************************************************

show_16bit_wert_feuchte:
		rcall	bin2BCD16

		load_p	Z,FEUCHTE

		mov		TEMP_0,BCD1
		swap	TEMP_0
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		mov		TEMP_0,BCD1
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		ldi		TEMP_0,','			// Komma
		st		Z+,TEMP_0

		mov		TEMP_0,BCD0
		swap	TEMP_0
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		ret

;*********************************************************************
;  Zeigt 16Bit-Wert an
;  Out   : Wert per UART schicken
;  Scratch-Reg: TEMP_A
;*********************************************************************

show_16bit_wert_druck:
		rcall	bin2BCD16

		load_p	Z,LUFTDRUCK

		mov		TEMP_0,BCD2
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		mov		TEMP_0,BCD1
		swap	TEMP_0
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		mov		TEMP_0,BCD1
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		mov		TEMP_0,BCD0
		swap	TEMP_0
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		ldi		TEMP_0,','			// Komma
		st		Z+,TEMP_0

		mov		TEMP_0,BCD1
		andi	TEMP_0,$0F
		ori		TEMP_0,'0'
		st		Z+,TEMP_0

		ret

;*********************************************************************				 

convert_temp:
		ldi		TEMP_0,' '
		sts		VORZEICHEN,TEMP_0

		ldi		TEMP_0,low(3962)        ; berechnet Temperatur in Hundertstel
		ldi		TEMP_1,high(3962)       ; Grad (Festkomma) bei 3,3V
		sub	    TEMP_L,TEMP_0
		sbc		TEMP_H,TEMP_1
		brcc	convert_temp_plus

		ldi		TEMP_0,'-'
		sts		VORZEICHEN,TEMP_0
		clr		TEMP_1
		clr		TEMP_0
		sub		TEMP_0,TEMP_L
		sbc		TEMP_1,TEMP_H
		mov		TEMP_L,TEMP_0
		mov		TEMP_H,TEMP_1
					
convert_temp_plus:
		mov		TEMP_0,TEMP_L
		mov		TEMP_1,TEMP_H

		rcall	show_16bit_wert_temp

		ret

;*********************************************************************				 

convert_feuchte:
		mov		MUL_1_L,FEUCHTE_L               ; berechnet Feuchte in Hundertstel
		mov		MUL_1_H,FEUCHTE_H               ; Prozent (Festkomma)
		ldi		TEMP_0,low(1037)				; * 1037
		mov		MUL_2_L,TEMP_0
		ldi		TEMP_0,high(1037)
		mov		MUL_2_H,TEMP_0
		rcall	math_mul16x16_32				; Feuchte * 1037
	                
		mov    FEUCHTE_L,MUL_E_1				; /256 -> * 4.05  (RF * 0,0405) in FEUCHTE_H/FEUCHTE_L
		mov    FEUCHTE_H,MUL_E_2

		mov    MUL_2_L,MUL_1_L					; Feuchte * Feuchte -> E3...E0
		mov    MUL_2_H,MUL_1_H
		rcall  math_mul16x16_32

		ldi    TEMP_0,low(4698)					; *4698				
		mov    MUL_1_L,TEMP_0
		ldi    TEMP_0,high(4698)
		mov    MUL_1_H,TEMP_0
		
		mov    MUL_2_L,MUL_E_1					; /256 -> * 18,35
		mov    MUL_2_H,MUL_E_2
		rcall  math_mul16x16_32					; * Low-16Bit des Ergebnisses

		sub    FEUCHTE_L,MUL_E_2				; /65636 -> * 0,00028
		sbc    FEUCHTE_H,MUL_E_3
		
		ldi    TEMP_0,low(-400)					; -4 und Korrektur des obersten Faktor 100
		mov    MUL_2_L,TEMP_0
		ldi    TEMP_0,high(-400)
		mov    MUL_2_H,TEMP_0
		add    FEUCHTE_L,MUL_2_L				; Low Byte
		adc    FEUCHTE_H,MUL_2_H				; High Byte
 
		mov		TEMP_0,FEUCHTE_L
		mov		TEMP_1,FEUCHTE_H
		rcall	show_16bit_wert_feuchte
 
		ret

;*********************************************************************				 

convert_druck:
		lds		XH,D2_VAL					; delta: D2-C5	
		lds		XL,D2_VAL+1

		lds		YH,C5_VAL
		lds		YL,C5_VAL+1

		sub		XL,YL
		sbc		XH,YH
		
		sts		DELTA,XH					; delta merken
		sts		DELTA+1,XL

		lds		TEMP_0,AA_VAL
		brpl	convert_druck_delta_positiv

		lds		TEMP_0,BB_VAL

convert_druck_delta_positiv:
		sts		C_VAL,TEMP_0

		lds		MUL_1_H,DELTA
		lds		MUL_1_L,DELTA+1
		lds		MUL_2_H,DELTA
		lds		MUL_2_L,DELTA+1
		rcall	math_muls16x16_32			; delta^2

		lds		MUL_1_L,C_VAL				; delta ^2 * AA oder BB
		rcall	math_mulu_32_8				; unsigned 32 (MUL_E_3...MUL_E_0) * 8 (MUL_1_L) -> MUL_1_H, TEMP_3...TEMP_0

		rcall	math_div_2_14				; delta^2 * AA /2^14 (delta positiv) oder delta^2 * BB /2^14 (delta negativ) 	

		lds		TEMP_0,CC_VAL

		load_p	X,1							; 2^CC

convert_druck_power_of_2:
		lsl		XL
		rol		XH
		dec		TEMP_0
		brne	convert_druck_power_of_2

		mov		MUL_1_H,XH
		mov		MUL_1_L,XL
		lds		MUL_2_H,DELTA
		lds		MUL_2_L,DELTA+1
		rcall	math_muls16x16_32			; delta mit 2^CC erweitern
		
		lds		TEMP_3,DELTA_14
		lds		TEMP_2,DELTA_14+1
		lds		TEMP_1,DELTA_14+2
		lds		TEMP_0,DELTA_14+3
		
		sub		MUL_E_0,TEMP_0				; (delta * 2^CC) - (delta^2 * xx /2^14) xx -> AA oder BB
		sbc		MUL_E_1,TEMP_1
		sbc		MUL_E_2,TEMP_2
		sbc		MUL_E_3,TEMP_3

		rcall	math_delta_div_cc			; ((delta * 2^CC) - (delta^2 * xx /2^14)) / 2^CC				

;*************** dUT Ende **********************

;*************** Offset ************************

		lds		MUL_1_H,C4_VAL
		lds		MUL_1_L,C4_VAL+1
		subi	MUL_1_L,low(1024)
		sbci	MUL_1_H,high(1024)

		lds		MUL_2_H,DUT
		lds		MUL_2_L,DUT+1
		rcall	math_muls16x16_32			; (C4-1024) * dUT

		rcall	math_div_2_14_2				; ((C4-1024) * dUT) / 2^14

		lds		XH,C2_VAL
		lds		XL,C2_VAL+1
		add		MUL_E_0,XL
		adc		MUL_E_1,XH
		adc		MUL_E_2,NULL
		adc		MUL_E_3,NULL				; C2 + (((C4-1024) * dUT) / 2^14)

		ldi		TEMP_0,2

convert_druck_4_loop:
		lsl		MUL_E_0						; *2		Vorzeichen???
		rol		MUL_E_1
		rol		MUL_E_2
		rol		MUL_E_3
		dec		TEMP_0
		brne	convert_druck_4_loop
		
		sts		OFFSET,MUL_E_3
		sts		OFFSET+1,MUL_E_2
		sts		OFFSET+2,MUL_E_1
		sts		OFFSET+3,MUL_E_0

;*************** Offset Ende **********************

;*************** Sens ************************
		
		lds		MUL_1_H,DUT
		lds		MUL_1_L,DUT+1
		lds		MUL_2_H,C3_VAL
		lds		MUL_2_L,C3_VAL+1

		rcall	math_muls16x16_32			; C3 * dUT 

		rcall	math_offset_2_10			; (C3 * dUT) / 2^10 (1024)

		lds		XH,C1_VAL
		lds		XL,C1_VAL+1
		add		MUL_E_0,XL
		adc		MUL_E_1,XH
		adc		MUL_E_2,NULL
		adc		MUL_E_3,NULL				; C1 + ((C3 * dUT) / 2^10 (1024))

		sts		SENS,MUL_E_3
		sts		SENS+1,MUL_E_2
		sts		SENS+2,MUL_E_1
		sts		SENS+3,MUL_E_0

;*************** Sens Ende **********************

;*************** X ************************

		lds		MUL_1_H,D1_VAL				; D1 - 7168
		lds		MUL_1_L,D1_VAL+1
		subi	MUL_1_L,low(7168)
		sbci	MUL_1_H,high(7168)

		ldi		TEMP_0,6

convert_druck_6_loop:
		lsr		MUL_1_H						; (D1 - 7168) / 64 (bleibt erweiter mit 256)
		ror		MUL_1_L
		dec		TEMP_0
		brne	convert_druck_6_loop

		lds		MUL_2_H,SENS+2				; Wertebereich???		
		lds		MUL_2_L,SENS+3		
		rcall	math_muls16x16_32			; sens * ((D1 - 7168) / 64)

		mov		MUL_E_0,MUL_E_1				; / 256
		mov		MUL_E_1,MUL_E_2
		mov		MUL_E_2,MUL_E_3
		ser		MUL_E_3
		sbrs	MUL_E_2,7
		clr		MUL_E_3
										
		lds		TEMP_0,OFFSET+3				; x1 - Offset 
		sub		MUL_E_0,TEMP_0
		lds		TEMP_0,OFFSET+2
		sbc		MUL_E_1,TEMP_0
		lds		TEMP_0,OFFSET+1
		sbc		MUL_E_2,TEMP_0
		lds		TEMP_0,OFFSET
		sbc		MUL_E_3,TEMP_0

		sts		X_VAL,MUL_E_3
		sts		X_VAL+1,MUL_E_2
		sts		X_VAL+2,MUL_E_1
		sts		X_VAL+3,MUL_E_0

;*************** X Ende **********************

;*************** Druck ************************

		lds		MUL_1_H,X_VAL+2				; Wertebereich????
		lds		MUL_1_L,X_VAL+3
		ldi		MUL_2_H,high(10)
		ldi		MUL_2_L,low(10)
		rcall	math_muls16x16_32			; X * 10

		ldi		TEMP_0,5					; /32

convert_druck_5_loop:
		clc
		sbrc	MUL_E_3,7					; positiv
		sec
		ror		MUL_E_3						; /2
		ror		MUL_E_2
		ror		MUL_E_1
		ror		MUL_E_0
		dec		TEMP_0
		brne	convert_druck_5_loop
			
		lds		XH,C7_VAL
		lds		XL,C7_VAL+1
		
		add		MUL_E_0,XL
		adc		MUL_E_1,XH
		adc		MUL_E_2,NULL
		adc		MUL_E_3,NULL

		mov		TEMP_1,MUL_E_1
		mov		TEMP_0,MUL_E_0
		
		ldi		TEMP_2,DRUCK_KORR.
		add		TEMP_0,TEMP_2
		adc		TEMP_1,NULL

		rcall	show_16bit_wert_druck

		ret


