
; ATMega88

; 27.01.2009 M'Soft Berlin

; 22.02.2009 V0.3
; Startmeldung eingebaut

; 26.02.2009 V0.4
; Umbau auf internen Takt, Clock fr HP03S aus 1,25MHz-Takt des RFM02 erzeugen

.equ	VER		= '0'
.equ	REV		= '4'

.include "m88def.inc"

.include "Definitionen.inc"

;****************************** Verktor-Liste ************************

.CSEG
		rjmp    Reset

.ORG	PCI2addr
		rjmp	irq_pin_change								; Sleep beenden
			 
;****************************** Programm-Beginn **********************

;*********************************************************************
;  Initialisierungsroutine
;*********************************************************************

.ORG	INT_VECTORS_SIZE

; Hardware initialisieren

Reset:
		ldi     TEMP_0,low(RAMEND) 			         		; Stack an das interne Ram-Ende
        out     SPL,TEMP_0
		ldi     TEMP_0,high(RAMEND)
        out     SPH,TEMP_0

; Port B *************************************************************

		ldi		TEMP_0,~((1<<FOST02_DATA) | (1<<FOST02_CLK)); Data hat externen PullUp, Clock auf L			
        out     PORTB,TEMP_0 
		ldi		TEMP_0,~(1<<FOST02_DATA)					; Data wird nur ber DDRB gesteuert 
		out     DDRB,TEMP_0

; Port C *************************************************************

		ldi		TEMP_0,0xFF									; PullUp ein			
        out     PORTC,TEMP_0 
		ldi		TEMP_0,(1<<HP03S_XCLR)
		out     DDRC,TEMP_0

; Port D *************************************************************

		ldi		TEMP_0,0xFF									; PullUp ein, CS auf H			
        out     PORTD,TEMP_0 
		ldi		TEMP_0,(1<<RFM02_SDI) | (1<<RFM02_SCK) | (1<<RFM02_CS) | (1<<HP03S_MCLK)	; Ausgnge 
		out     DDRD,TEMP_0

; I2C	    **********************************************************

		ldi 	TEMP_0,(1<<TWPS0)							; Vorteiler 4
		sts 	TWSR,TEMP_0	
		ldi 	TEMP_0,I2C_CLOCK
		sts 	TWBR,TEMP_0									; Bitrate setzen

; Timer 0 32kHz ******************************************************

		ldi		TEMP_0,(1<<COM0A0) | (1<<WGM01)				; CTC, Toggle OC0A, 32,xxxkHz Clock fr HP03S 
		out		TCCR0A,TEMP_0
		ldi		TEMP_0,(1<<CS02) | (1<<CS01)				; MCLK ein
		out		TCCR0B,TEMP_0
		ldi		TEMP_0,((RFM_CLK/32768)/2)-1				; Comparewert
		out		OCR0A,TEMP_0

; PIN Change *********************************************************

		ldi		TEMP_0,(1<<RFM02_IRQ)
		sts		PCMSK2,TEMP_0
		ldi		TEMP_0,(1<<SE) | (1<<SM1)					; Sleep Enable, Mode PowerDown
		out		SMCR,TEMP_0

;*********************************************************************				 

; Software initialisieren

		ldi		TEMP_0,50									; 400ms

init_wait_loop:
		rcall	wait_20ms
		dec		TEMP_0
		brne	init_wait_loop

		rcall	rfm02_init									; Sender initialisieren	

		rcall	fost02_reset								; FOST02 initialisieren

		rcall	hp03_read_eeprom							; Kalibierungsdaten holen

		rcall	init_data_buf								; setzt DATA_BUF erstmal auf 0x55 -> kein Sensor

		sei													; Interrupt freigeben

;*********************************************************************
;  Main-Loop
;*********************************************************************

main:		
		rcall	hp03s_luftdruck
		rcall	convert_druck

		rcall	fost02_temperatur
		rcall	convert_temp

		rcall	fost02_feuchte
		rcall	convert_feuchte

		rcall	checksum

		rcall	rfm02_send_data

		ldi		TEMP_0,(1<<PCIF2)							; evtl. noch anstehenden IRQ lschen
		out		PCIFR,TEMP_0

		ldi		TEMP_0,(1<<PCIE2)							; Pin-Change-IRQ ein
		sts		PCICR,TEMP_0

		sleep

		rjmp	main

;*********************************************************************				 

irq_pin_change:
		sts		PCICR,NULL									; Pin-Change-IRQ aus

		reti

;*********************************************************************				 

.include "Subroutinen.inc"
.include "Mathe.inc"
.include "FOST02.inc"
.include "RFM02.inc"
.include "HP03S.inc"

buf_default:
	.db	0x53,0x50,0x51,0x20,0x20,0x20,0x20,0x20,0x20,0x52,0x20,0x20,0x20,0x20,0x20,0x20		// Sub-Sensor 2
	.db	0x53,0x20,0x20,0x20,0x20,0x20,0x20,0x00                                             // Checksumme

